var {
    failure_callback,
    checkVar,
    isValidEmail
} = require('../middleware/common');


module.exports = {

    login: function (req, res, next) {

        try {
            const { email, password } = req.body

            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            if (checkVar(password)) {
                return failure_callback(res, ['password is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    Set_location_radius: function (req, res, next) {

        try {
            const { user_id, current_location, radius, latitude, longitude } = req.body

            if (checkVar(user_id)) {
                return failure_callback(res, ['user_id is required', 400])
            }
            if (checkVar(current_location)) {
                return failure_callback(res, ['current_location is required', 400])
            }
            if (checkVar(radius)) {
                return failure_callback(res, ['radius is required', 400])
            }
            if (checkVar(latitude)) {
                return failure_callback(res, ['latitude is required', 400])
            }
            if (checkVar(longitude)) {
                return failure_callback(res, ['longitude is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    sport_Sub_category_list: function (req, res, next) {

        try {
            const { sport_category_id } = req.body

            if (checkVar(sport_category_id)) {
                return failure_callback(res, ['sport_category_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    Select_Sport_category: function (req, res, next) {

        try {
            const { user_id, sport_category_id, sport_sub_category_id } = req.body

            if (checkVar(user_id)) {
                return failure_callback(res, ['user_id is required', 400])
            }
            if (checkVar(sport_category_id)) {
                return failure_callback(res, ['sport_category_id is required', 400])
            }
            if (checkVar(sport_sub_category_id)) {
                return failure_callback(res, ['sport_sub_category_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    Selected_Sport_category: function (req, res, next) {

        try {
            const { user_id } = req.body

            if (checkVar(user_id)) {
                return failure_callback(res, ['user_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    update_profile: function (req, res, next) {

        try {
            const { user_id,fname,lname,about_self,birthday,gender,height,location,right_or_left_handded,height_type,nationality,hobbies,latitude,longitude } = req.body

            if (checkVar(user_id)) {
                return failure_callback(res, ['user_id is required', 400])
            }
            if (checkVar(fname)) {
                return failure_callback(res, ['fname is required', 400])
            }
            if (checkVar(lname)) {
                return failure_callback(res, ['lname is required', 400])
            }
            if (checkVar(about_self)) {
                return failure_callback(res, ['about_self is required', 400])
            }
            if (checkVar(birthday)) {
                return failure_callback(res, ['birthday is required', 400])
            }
            if (checkVar(gender)) {
                return failure_callback(res, ['gender is required', 400])
            }
            if (checkVar(height)) {
                return failure_callback(res, ['height is required', 400])
            }
            if (checkVar(location)) {
                return failure_callback(res, ['location is required', 400])
            }
            if (checkVar(right_or_left_handded)) {
                return failure_callback(res, ['right_or_left_handded is required', 400])
            }
            if (checkVar(height_type)) {
                return failure_callback(res, ['height_type is required', 400])
            }
            if (checkVar(nationality)) {
                return failure_callback(res, ['nationality is required', 400])
            }
            if (checkVar(hobbies)) {
                return failure_callback(res, ['hobbies is required', 400])
            }
            if (checkVar(latitude)) {
                return failure_callback(res, ['latitude is required', 400])
            }
            if (checkVar(longitude)) {
                return failure_callback(res, ['longitude is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    create_profile: function (req, res, next) {

        try {
            const {user_id, fname, lname, about_self, birthday, gender, height, location, right_or_left_handded, height_type } = req.body

            if (checkVar(user_id)) {
                return failure_callback(res, ['user_id is required', 400])
            }
            if (checkVar(fname)) {
                return failure_callback(res, ['fname is required', 400])
            }
            if (checkVar(lname)) {
                return failure_callback(res, ['lname is required', 400])
            }
            if (checkVar(about_self)) {
                return failure_callback(res, ['about_self is required', 400])
            }
            if (checkVar(birthday)) {
                return failure_callback(res, ['birthday is required', 400])
            }
            if (checkVar(gender)) {
                return failure_callback(res, ['gender is required', 400])
            }
            if (checkVar(height)) {
                return failure_callback(res, ['height is required', 400])
            }
            if (checkVar(location)) {
                return failure_callback(res, ['location is required', 400])
            }
            if (checkVar(right_or_left_handded)) {
                return failure_callback(res, ['right_or_left_handded is required', 400])
            }
            if (checkVar(height_type)) {
                return failure_callback(res, ['height_type is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


}